@extends('layouts.admin')
@section('title')
    Rotary • Club of Lekki Phase One
@endsection

@section('styles')

@endsection

@section('page')
<a href="{{url('/projects')}}">Projects</a>
@endsection


@section('content')
	
			<section class="ls section_padding_top_50 section_padding_bottom_50 columns_padding_5">
				<div class="container-fluid">

					<div class="row">
						<div class="col-sm-12">
							<h3>Club 
								<small>Projects</small>
							</h3>
						</div>
					</div>
					<!-- .row -->

					<div class="row">
						<div class="col-sm-12">
							<div class="with_border with_padding">


								<span class="pull-right">
											<a href="{{url('/addprojects')}}" class="theme_button small_button">Add Projects</a>
										</span>
								<!-- <h3 class="divider_40">Bootstrap Stripped Table</h3> -->
								<table class="table table-striped">
									<thead>
										<tr>
											<th>#</th>
											<th>Title</th>
											<th>Description</th>
											<th>Tags</th>
											<th>Actions</th>
										</tr>
									</thead>
									<?php $i=1;?>
									<tbody>
										   @foreach ($projects as $m)
										<tr>
											<td>{{$i++}}</td>
											<td>{{$m['title']}}</td>
											<td>
											<?php	 $yourString =$m['text'];
												  if (strlen($yourString) > 200){
				                                    $maxLength = 199;
				                                    $yourString = substr($yourString, 0, $maxLength);
				                                    $yourString= $yourString.'...';
				                                    echo $yourString;

				                                }else{
				                                     echo $yourString;
				                                }?>

											</td>
											<td>{{$m['slug']}}</td>
											<td>
												<!-- <a class="theme_button small_button" href="{{url('/viewmembers')}}/{{$m['sn']}}">View Member</a> -->
												<a href="{{url('/editproject')}}/{{$m['id']}}" class="theme_button small_button">Edit Project</a>
												<!-- <a href="{{url('/disablemembers')}}/{{$m['sn']}}" class="theme_button small_button">Disable Member</a> -->
												<?php if($m['active'] == 1 ){ ?>
													<button  class="theme_button small_button" onclick="disprojectbutton({{$m['id']}})"  >Disable Project</button>
											   <?php }else{ ?>
											    	<button  class="theme_button small_button" onclick="enableproject({{$m['id']}});" >Enable project</button>
											    <?php } ?>
												
												
												<a href="{{url('/projectphoto')}}/{{$m['id']}}" class="theme_button small_button">Upload Project Pics</a>
												
											</td>
										</tr>
										    @endforeach
									</tbody>

								</table>

							{!! $projects->render() !!} 
							</div>
							<!-- .with_border -->

						</div>
						<!-- .col-* -->
					</div>
					<!-- .row -->


					<!-- .row -->

				</div>
				<!-- .container -->
			</section>

@endsection



@section('script')
<script src="../js/joseadebag.js"></script>
@endsection
